package cn.com.duiba.kjy.api.dto.aivideo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人AI跟拍视频记录表
 *
 * @author xuzhigang
 * @date 2021-4-26 16:23:49
 */
@Data
public class AiVideoRecordDto implements Serializable {
    private static final long serialVersionUID = 1259884787371741061L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 视频地址
     */
    private String videoUrl;

    /**
     * 直播记录id
     */
    private Long streamId;

    /**
     * 录制状态
     *
     * @see cn.com.duiba.kjy.api.enums.aivideo.AiVideoStatusEnum
     */
    private Integer videoStatus;

    /**
     * 视频模板id
     * tb_ai_video_template.id
     */
    private Long templateId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;


}

