package cn.com.duiba.kjy.api.params.reward;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 点对点抽奖活动创建
 * @author xiongkai
 * @version 1.0
 * @date 2021-03-09 13:40
 */
@Data
public class RewardActivityAddParam implements Serializable {

    private static final long serialVersionUID = -6432308702215630923L;

    /**
     * 销售人员id
     */
    private Long sellerId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 活动类型 1=点对点 2=社群
     * @see cn.com.duiba.kjy.api.enums.reward.RewardActivityTypeEnum
     */
    private Integer activityType;

    /**
     * 活动关联的资源类型 1=视频
     * @see cn.com.duiba.kjy.api.enums.reward.RewardResourceTypeEnum
     */
    private Integer resourceType;

    /**
     * 活动关联的id
     */
    private Long resourceId;

    /**
     * 开奖时间
     */
    private Date awardTime;

    /**
     * 奖品名称
     */
    private String awardName;

    /**
     * 奖品图片
     */
    private String awardImage;

    /**
     * 奖品总库存
     */
    private Integer awardStock;
}
