package cn.com.duiba.kjy.api.remoteservice.aivideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoPhotoFrameRelationDto;

import java.util.List;
import java.util.Map;

/**
 * ai跟拍视频相框关联关系service
 */
@AdvancedFeignClient
public interface RemoteAiVideoPhotoFrameRelationService {

    /**
     * 根据视频模版id查询视频与相框的关联关系
     *
     * @param videoTemplateId 视频模版id
     * @return 视频与相框的关联关系
     */
    List<AiVideoPhotoFrameRelationDto> getRelationsByVideoTemplateId(Long videoTemplateId);

    /**
     * 批量建立视频与相框的关联关系
     *
     * @param videoTemplateId 视频模版id
     * @param photoFrameIds   相框id集合
     * @return 建立关系是否成功
     */
    boolean addRelations(Long videoTemplateId, List<Long> photoFrameIds);

    /**
     * 批量删除视频与相框的关联关系
     *
     * @param videoTemplateId 视频模版id
     * @return 删除视频与相框的关联关系
     */
    boolean deleteRelations(Long videoTemplateId);

    Map<Long, Integer> batchSelectVideoRelationCount(List<Long> videoTemplateIds);

}
