package cn.com.duiba.kjy.api.remoteservice.aivideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoPhotoFrameDto;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoTemplateDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;

/**
 * ai跟拍视频相框service
 */
@AdvancedFeignClient
public interface RemoteAiVideoPhotoFrameService {

    /**
     * 批量添加相框
     *
     * @param photoFrameDtos 相框集合
     * @return 相框id
     */
    List<Long> addPhotoFrames(List<AiVideoPhotoFrameDto> photoFrameDtos);

    /**
     * 批量删除相框
     *
     * @param photoFrameIds 相框id集合
     * @return 删除结果
     */
    boolean deletePhotoFrames(List<Long> photoFrameIds);

    /**
     * 根据id批量查询相框
     *
     * @param photoFrameIds 相框id集合
     * @return 相框集合
     */
    List<AiVideoPhotoFrameDto> list(List<Long> photoFrameIds);

}
