package cn.com.duiba.kjy.api.remoteservice.guess;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.guess.GuessQuestionDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;

/**
 * 猜你想问rpc
 * @author 吴文哲
 * @date 2021/4/30 2:00 下午
 **/
@AdvancedFeignClient
public interface RemoteGuessQuestionService {

    /**
     * 根据主键查询问题详情 不过滤逻辑删除
     * @param id 主键id
     * @return 问题详情
     */
    GuessQuestionDto getGuessQuestionById(Long id);

    /**
     * 根据主键ID查询(过滤逻辑删除)
     * @param questionIds 问题主键id
     * @return 猜你所想问题列表
     */
    List<GuessQuestionDto> findByIds(List<Long> questionIds);

    /**
     * 查询猜你所想问题列表
     * @param id 主键id
     * @param pageQuery 分页查询参数
     * @return 猜你所想列表
     */
    List<GuessQuestionDto> listGuessQuestion(Long id, PageQuery pageQuery);

    /**
     * 统计猜你所想数量
     * @param id 主键id
     * @return 统计总数
     */
    Integer countGuessQuestion(Long id);

    /**
     * 新增猜你所想问题
     * @param guessQuestionDto 问题详情
     * @return 新增结果
     */
    Integer saveGuessQuestion(GuessQuestionDto guessQuestionDto);

    /**
     * 更新猜你所想问题
     * @param guessQuestionDto 问题详情
     * @return 更新结果
     */
    Integer updateGuessQuestion(GuessQuestionDto guessQuestionDto);

    /**
     * 根据主键逻辑删除
     * @param id 主键id
     * @return 删除结果
     */
    Integer delGuessQuestion(Long id);


    /**
     * 根据文章id 查询关联的问题列表 按照关联的表的创建时间倒序
     * redis缓存2分钟
     * @param contentId 文章id
     * @return 猜你所想问题列表
     */
    List<GuessQuestionDto> listByContentIdWithCache(Long contentId);

}
