package cn.com.duiba.kjy.api.enums.redpacket;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/1/7 19:28
 */
public enum SellerPromotionStateEnum {

    NOT_USE(0, "未使用"),

    USED(1, "已使用"),

    USING(2, "使用中"),

    ;

    private Integer code;
    private String desc;

    SellerPromotionStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, SellerPromotionStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SellerPromotionStateEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static SellerPromotionStateEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
