package cn.com.duiba.kjy.api.remoteservice.fission;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.fission.FissionAwardDto;
import cn.com.duiba.kjy.api.params.fission.FissionAwardQueryParam;

import java.util.List;

/**
 * 远程微信裂变奖品服务
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月28日 16:35
 **/

@AdvancedFeignClient
public interface RemoteFissionAwardService {

    /**
     * 获取奖品池
     * pageSize必传，pageNo不传的话默认为1
     * @param invite 是否为邀请用户
     * @param pageNo 当前页码
     * @param pageSize 每页条数
     * @return
     */
    List<FissionAwardDto> getAwards(Integer invite, Integer pageNo, Integer pageSize);

    /**
     * 根据id获取奖品
     * @param invite 是否是邀请用户
     * @param id 奖品id
     * @return
     */
    FissionAwardDto getAwardById(Integer invite, Long id);

    /**
     * 根据id集合查询
     * @param ids
     * @return
     */
    List<FissionAwardDto> findByIds(List<Long> ids);

    /**
     * 分页查询奖品信息
     * @param param 分页查询条件
     * @return 奖品信息集合
     */
    List<FissionAwardDto> findByParam(FissionAwardQueryParam param);

    /**
     * 根据条件查询总记录数
     * @param param 查询条件
     * @return 记录数
     */
    Long countByParam(FissionAwardQueryParam param);

    /**
     * 根据id查询
     * @param id 主键
     * @return 奖品信息
     */
    FissionAwardDto findById(Long id);

    /**
     * 新增或更新
     * @param fissionAwardDto 奖品信息
     * @return 主键
     */
    Long saveOrUpdate(FissionAwardDto fissionAwardDto);

    /**
     * 更新状态
     * @param id 主键
     * @param halted 状态
     * @see cn.com.duiba.kjy.api.enums.fission.FissionAwardHaltedEnum
     * @return 执行结果
     */
    int updateHaltedById(Long id, Integer halted);
}
