package cn.com.duiba.kjy.api.dto.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmSellerBizTypeEnum;
import cn.com.duiba.kjy.api.enums.crm.CrmSellerRoleTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
* 销售CRM用户信息dto
*/
@Data
public class CrmSellerDto implements Serializable {

    private static final long serialVersionUID = -3574797459978578046L;
    /**
    * 主键
    */
    private Long id;

    /**
    * ssoID
    */
    private Long ssoId;

    /**
    * 钉钉用户ID
    */
    private String dingdingId;

    /**
    * 销售名称
    */
    private String sellerName;

    /**
    * 角色类型，1销售,2管理员
     * @see CrmSellerRoleTypeEnum
    */
    private Integer roleType;

    /**
    * 业务类型，1直播线
     * @see CrmSellerBizTypeEnum
    */
    private Integer bizType;

    /**
    * 是否删除，1=已删除，0=未删除
    */
    private Integer deleted;

    /**
    * 备注
    */
    private String remark;

    /**
     * 创建时间
     */
    private Date gmtCreate;


}

