package cn.com.duiba.kjy.api.dto.survey;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 问券表
 * @author kjj mybatis generator 
 * 2020-11-24
 */
@Data
public class SurveyDto implements Serializable {
    private static final long serialVersionUID = 16062078607415412L;

    /**
     * id
     * */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 目标对象 1：直播代理人
     * @see cn.com.duiba.kjy.api.enums.survey.SurveyTargetTypeEnum
     */
    private Integer targetType;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 业务类型 1：直播
     * @see cn.com.duiba.kjy.api.enums.survey.SurveyBizTypeEnum
     */
    private Integer bizType;

    /**
     * 标题
     */
    private String title;

    /**
     * 版本
     */
    private Integer version;

    /**
     * B端名称
     */
    private String name;

    /**
     * 问候语
     */
    private String prefix;

    /**
     * 状态
     * @see cn.com.duiba.kjy.api.enums.survey.SurveyStatusEnum
     */
    private Integer status;

    /**
     * 删除标志位(0-正常 1-删除)
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;

    /**
     * 备注
     */
    private String remark;

    /**
     * 背景设置
     */
    private String background;

}