package cn.com.duiba.kjy.api.enums.content;

import lombok.Getter;

import java.util.Objects;

/**
 * 素材标签类型
 * @author 吴文哲
 * @date 2020-05-09 17:01
 **/
@Getter
public enum ContentTagTypeEnum {

    TIMELINE_CONTENT("timeline_content","发圈素材"),
    GRASS_CONTENT("grass_content","种草素材"),
    COMPANY_AREA("company_area","公司专区"),
    SUCCESS_CASES("success_cases","成功案例"),
    ;

    /**
     * 类型
     */
    private String type;

    /**
     * 描述
     */
    private String desc;

    ContentTagTypeEnum(String type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public static ContentTagTypeEnum getByType(String type) {
        for (ContentTagTypeEnum esEnum : ContentTagTypeEnum.values()) {
            if (Objects.equals(esEnum.getType(), type)) {
                return esEnum;
            }
        }
        return null;
    }


}
