package cn.com.duiba.kjy.api.remoteservice.clockin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clockin.SellerClockInProgressDto;

/**
 * 打卡进度
 *
 * @author xuzhigang
 * @date 2021/4/14 9:45 上午
 **/
@AdvancedFeignClient
public interface RemoteSellerClockInProgressService {

    /**
     * 根据sellerId和打卡类型查询未结束的打卡进度
     *
     * @param sellerId 销售id
     * @param clockInType 打卡类型 {@link cn.com.duiba.kjy.api.enums.clockin.ClockInTypeEnum}
     * @return 打卡进度
     */
    SellerClockInProgressDto selectNotEndBySellerIdAndClockType(Long sellerId, Integer clockInType);
}
