package cn.com.duiba.kjy.api.remoteservice.system;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.system.SystemConfigDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019/7/20 14:12
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSystemConfigService {

    /**
     * 根据代码获取配置
     * @param code
     * @return
     */
    SystemConfigDto getConfigByCode(String code);

    /**
     * 根据代码更新
     * @param systemConfigDto
     * @return
     */
    Integer updateByCode(SystemConfigDto systemConfigDto);

    /**
     * 根据codes查询所有符合条件的配置
     * @param codes 查询条件
     * @return 查询结果
     */
    List<SystemConfigDto> getConfigByCodes(List<String> codes);

    /**
     * 批量插入
     * @param list 插入数据
     * @return 插入结果
     */
    Integer save(List<SystemConfigDto> list);

    /**
     * 批量更新
     * @param list 更新数据
     * @return 更新结果
     */
    Integer update(List<SystemConfigDto> list);

}
