package cn.com.duiba.kjy.api.util;

import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.util.Objects;

/**
 * @author 吴文哲
 * @date 2019-08-08 13:29
 **/
@Slf4j
public class BeanUtil {


    /**
     * 判断对象是否所有的属性都为空
     *
     * @param obj
     * @return
     */
    public static boolean isAllFieldNull(Object obj) {
        if (obj == null) {
            return true;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                Object object = field.get(obj);
                if (Objects.nonNull(object)) {
                    return false;
                }
            } catch (IllegalAccessException e) {
                log.error("IllegalAccessException:", e);
            }
        }
        return true;


    }

    /**
     * 判断当前对象是否所有属性都不为null
     *
     * @param obj
     * @return
     */
    public static boolean isAllFieldNotNull(Object obj) {
        if (obj == null) {
            return false;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                Object object = field.get(obj);
                if (Objects.isNull(object)) {
                    return false;
                }
            } catch (IllegalAccessException e) {
                log.error("IllegalAccessException:", e);
            }
        }
        return true;

    }

    /**
     * 判断当前对象的所有属性 是否都不为null 且不为 ""
     *
     * @param obj
     * @return
     */
    public static boolean isAllFieldNotBlank(Object obj) {
        if (obj == null) {
            return false;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                Object object = field.get(obj);
                if (Objects.isNull(object) || object.toString().equals("")) {
                    return false;
                }
            } catch (IllegalAccessException e) {
                log.error("IllegalAccessException:", e);
            }
        }
        return true;

    }


}
