/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums;

import cn.com.duiba.kjy.api.constant.UserExtTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public enum OATypeEnum {
    CONTENT_MAIN_OA(1, "\u5185\u5bb9\u4e3b\u4f53\u516c\u4f17\u53f7"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.OA;
        }
    }
    ,
    VIP_OA(2, "\u4ed8\u8d39\u7528\u6237\u7684VIP\u4e13\u5c5e\u516c\u4f17\u53f7"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.VIP;
        }
    }
    ,
    MP(3, "\u5ba2\u96c6\u96c6\u4e3b\u4f53\u5c0f\u7a0b\u5e8f"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.MP;
        }
    }
    ,
    CLIENT_PUSH_MP(4, "\u5ba2\u6237\u63a5\u6536\u79c1\u4fe1\u6d88\u606f\u7684\u5c0f\u7a0b\u5e8f"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.CLIENT_MP;
        }
    }
    ,
    FISSION_MP(5, "\u5fae\u4fe1\u88c2\u53d8\u5c0f\u7a0b\u5e8f"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.FISSION_MP;
        }
    }
    ,
    GAME_MP(6, "\u62bd\u5956\u6a21\u677f\u5c0f\u7a0b\u5e8f"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.GAME_MP;
        }
    }
    ,
    GREETING_MP(7, "\u8282\u65e5\u8d3a\u5361\u5c0f\u7a0b\u5e8f"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.GREETING_MP;
        }
    }
    ,
    INNER_SALE(8, "\u5185\u90e8\u9500\u552eweb\u5e94\u7528"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return null;
        }
    }
    ,
    LIVE_USER_MP(9, "\u76f4\u64ad\u7528\u6237\u7aef"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_USER_MP;
        }
    }
    ,
    LIVE_ANCHOR_MP(10, "\u76f4\u64ad\u4e3b\u7aef"){

        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_ANCHOR_MP;
        }
    };

    private Integer type;
    private String desc;
    private static final List<Integer> MP_TYPE_LIST;

    private OATypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean isMp(Integer type) {
        if (type == null) {
            return false;
        }
        return MP_TYPE_LIST.contains(type);
    }

    public boolean isMp() {
        return this == MP || this == CLIENT_PUSH_MP || this == FISSION_MP || this == GAME_MP || this == GREETING_MP;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e : OATypeEnum.values()) {
            if (!Objects.equals(type, e.getType())) continue;
            return e;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684oa\u7c7b\u578b");
    }

    public abstract UserExtTypeEnum change2ExtTypeEnum();

    static {
        MP_TYPE_LIST = new ArrayList<Integer>();
        MP_TYPE_LIST.add(MP.getType());
        MP_TYPE_LIST.add(CLIENT_PUSH_MP.getType());
        MP_TYPE_LIST.add(FISSION_MP.getType());
        MP_TYPE_LIST.add(GAME_MP.getType());
        MP_TYPE_LIST.add(GREETING_MP.getType());
        MP_TYPE_LIST.add(LIVE_USER_MP.getType());
        MP_TYPE_LIST.add(LIVE_ANCHOR_MP.getType());
    }
}

