package cn.com.duiba.kjy.api.dto.invitationLetter;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户访问邀请函记录表
 * @author kjj mybatis generator 
 * 2020-02-18
 */
@Data
public class VisitorInvitationLetterRecordDto implements Serializable {
    private static final long serialVersionUID = 15820119879715184L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 邀请函ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 邀请函配置ID，对应tb_seller_invitation_letter_conf.id
     */
    private Long confId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 受邀人姓名
     */
    private String visitorName;

    /**
     * 受邀人联系电话
     */
    private String visitorPhone;

    /**
     * 阅读标志：0=未读、1=已读
     * @see cn.com.duiba.kjy.api.enums.invitationLetter.InvitationLetterReadMarkEnum
     */
    private Integer readMark;

    /**
     * 行为
     * @see cn.com.duiba.kjy.api.enums.invitation.InvitationActionTypeEnum
     */
    private Integer actionType;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}