package cn.com.duiba.kjy.api.enums.greeting;

/**
 * 贺卡海报开关枚举
 */
public enum PosterSwitchEnum {

    OPEN(1, "贺卡海报开关开"),
    CLOSE(2, "贺卡海报开关关"),
    ;


    private Integer code;
    private String value;

    PosterSwitchEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public Integer getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    /**
     * 根据编码查询枚举。
     *
     * @param code 编码。
     * @return 枚举。
     */
    public static PosterSwitchEnum getByCode(Integer code) {
        for (PosterSwitchEnum value : PosterSwitchEnum.values()) {
            if (code.equals(value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 枚举是否包含此code
     *
     * @param code 枚举code
     * @return 结果
     */
    public static Boolean contains(Integer code) {
        for (PosterSwitchEnum value : PosterSwitchEnum.values()) {
            if (code.equals(value.getCode())) {
                return true;
            }
        }
        return false;
    }

}
