package cn.com.duiba.kjy.api.remoteservice.sms.template;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sms.SmsTemplateDto;

import java.util.List;

/**
 * @author gxy
 * @date 2021/5/27 3:16 下午
 */
@AdvancedFeignClient
public interface RemoteTemplateService {

    /**
     * 根据ids批量查询
     * @param list ids
     * @return 查询结果
     */
    List<SmsTemplateDto> selectTemplateByIds(List<Long> list);

    /**
     * 根据id查询
     * @param id 主键
     * @return 查询结果
     */
    SmsTemplateDto selectById(Long id);

    /**
     * 新增
     * @param dto 新增记录
     * @return 新增结果
     */
    Integer save(SmsTemplateDto dto);

    /**
     * 修改
     * @param dto 修改记录
     * @return 修改结果
     */
    Integer update(SmsTemplateDto dto);

    /**
     * 根据code查询
     * @param templateCode 模版code
     * @return 查询结果
     */
    SmsTemplateDto selectByCode(String templateCode);
}
