package cn.com.duiba.kjy.api.remoteservice.aivideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoClassificationDto;

import java.util.List;
import java.util.Map;

/**
 * ai跟拍助手-视频栏目remoteService
 *
 * @author ZhangJun
 * @date 2021/5/27 11:20 上午
 */
@AdvancedFeignClient
public interface RemoteAiVideoClassificationService {

    /**
     * 查询所有栏目列表，按照创建时间顺序排列
     *
     * @return 所有栏目列表
     */
    List<AiVideoClassificationDto> listAll();

    /**
     * 查询所有上架的栏目，按照自定义顺序排列
     *
     * @return 上架的栏目列表
     */
    List<AiVideoClassificationDto> listOnShelve();

    /**
     * 查询所有下架的栏目，按照修改时间顺序排列
     *
     * @return 下架的栏目列表
     */
    List<AiVideoClassificationDto> listOffShelve();

    /**
     * 根据栏目名称查询栏目
     *
     * @param classificationName 栏目名称
     * @return 栏目entity
     */
    AiVideoClassificationDto findByName(String classificationName);

    /**
     * 新增栏目
     *
     * @param classificationName 栏目名称
     * @return 新增结果
     */
    boolean add(String classificationName);

    /**
     * 修改栏目
     *
     * @param dto 栏目信息
     * @return 修改结果
     */
    boolean update(AiVideoClassificationDto dto);

    /**
     * 根据主键id删除栏目
     *
     * @param id 栏目id
     * @return 删除结果
     */
    boolean deleteById(Long id);

    /**
     * 上架栏目
     *
     * @param id 栏目id
     * @return 上架结果
     */
    boolean putOnShelve(Long id);

    /**
     * 下架栏目
     *
     * @param id 栏目id
     * @return 下架结果
     */
    boolean putOffShelve(Long id);

    /**
     * 栏目自定义排序
     *
     * @param moveId 被移动的栏目id
     * @param targetId 目标位置的下一个栏目id
     * @return 排序结果
     */
    boolean sort(Long moveId, Long targetId);

    /**
     * 获取所有栏目id与名称的对应关系
     *
     * @return 栏目名称map
     */
    Map<Long, String> listAllClassificationName();

}
