package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerVisitRelationStatisticsDto;
import cn.com.duiba.kjy.api.params.seller.SellerVisitRelationStatisticsQueryParam;

import java.util.List;

/**
 * @author liuchao1
 * @date 2020/6/11 15:34
 */
@AdvancedFeignClient
public interface RemoteSellerVisitRelationStatisticsService {

    /**
     * 根据参数统计总数
     * @param param 查询参数
     * @return 符合条件的总数
     */
    Integer selectCount(SellerVisitRelationStatisticsQueryParam param);

    /**
     * 根据参数查询，支持分页
     * @param param 查询参数
     * @return 代理人访客关系链汇总数据集合
     */
    List<SellerVisitRelationStatisticsDto> selectList(SellerVisitRelationStatisticsQueryParam param);

}
