package cn.com.duiba.kjy.api.remoteservice.aivideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoTemplateDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;

/**
 * ai跟拍service
 * @author chentiecheng
 * @date 2021/4/26 2:44 下午
 */
@AdvancedFeignClient
public interface RemoteAiVideoTemplateService {

    /**
     * 视频模板列表
     * @param query 分页参数
     * @return 视频模板
     */

    List<AiVideoTemplateDto> selectPage(PageQuery query);

    /**
     * 查询记录数 后台专用
     * @return 记录数
     */
    long count();

    /**
     * 新增视频模板
     *
     * @param dto 视频模板参数
     * @return true-成功 false-失败
     */
    boolean insert(AiVideoTemplateDto dto);

    /**
     * 更新视频模版
     * @param dto 视频模板参数
     * @return true-成功 false-失败
     */
    boolean update(AiVideoTemplateDto dto);

    /**
     * 删除
     * @param id 主键id
     * @return true-删除成功 false-删除失败
     */
    boolean delete(Long id);

    /**
     * 根据id获取模版详情
     * @param id 主键id
     * @return 详情
     */
    AiVideoTemplateDto findById(Long id);
}
