package cn.com.duiba.kjy.api.remoteservice.customize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.customize.PosterCustomInfoDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.customize.PosterCustomInfoSearchParam;

/**
 * @auther: linjianhui
 * @date: 2019-08-30 14:26
 * @description: 海报自定义
 */
@AdvancedFeignClient
public interface RemotePosterCustomInfoService {

    /**
     * 插入或更改自定义海报信息
     * @param posterCustomInfoDto
     * @return
     */
    Long addOrUpdate(PosterCustomInfoDto posterCustomInfoDto);

    /**
     * 根据id查询自定义海报信息
     * @param id
     * @return
     */
    PosterCustomInfoDto findById(Long id);

    /**
     * 查询自定义海报列表
     * @param param
     * @return
     */
    Page<PosterCustomInfoDto> selectList(PosterCustomInfoSearchParam param);

    /**
     * 根据id删除自定义海报
     * @param id
     * @return
     */
    Integer deleteById(Long id);

}
