package cn.com.duiba.kjy.api.enums.crm.customer;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 合作类型
 * @date 2020/12/18 11:20
 */
public enum CustomerCooperateTypeEnum {

    /**
     * 确认合作 合作类型
     */
    NEW_COOPERATION(1, "次签"),
    LONG_TIME_COOPERATION(2, "年框"),
    ;

    private Integer code;
    private String desc;

    CustomerCooperateTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CustomerCooperateTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CustomerCooperateTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static CustomerCooperateTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
