package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/9/23 1:46 PM
 */
public enum InteractionSelectionTypeEnum {

    SINGLE(0, "单选"),
    MULTIPLE(1, "多选"),
    ;

    private Integer type;

    private String desc;

    InteractionSelectionTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, InteractionSelectionTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionSelectionTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static InteractionSelectionTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static InteractionSelectionTypeEnum getByInteractionType(Byte interactionType) {
        if (interactionType == null) {
            return null;
        }
        if (InteractionTypeEnum.isMultiple(interactionType)) {
            return MULTIPLE;
        }
        if (InteractionTypeEnum.isSingle(interactionType)) {
            return SINGLE;
        }
        return null;
    }
}
