package cn.com.duiba.kjy.api.enums.layer;

import java.util.HashMap;
import java.util.Map;

/**
 * 弹层显示条件枚举
 * 1:有效时间内首次访问 2:有效时间内每次访问直到点击
 * @author 吴文哲
 * @date 2020-03-25 17:42
 **/
public enum LayerDisplayConditionEnum {

    FIRST_VISIT(1,"有效时间内首次访问"),
    UNTIL_CLICK(2,"有效时间内每次访问直到点击"),
    EVERY_DAY_UNTIL_CLICK(3,"有效时间内每次访问直到点击(每个自然日只弹出一次)"),
    ;

    /**
     * 显示类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    LayerDisplayConditionEnum(Integer type ,String desc){
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, LayerDisplayConditionEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LayerDisplayConditionEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }
    public static LayerDisplayConditionEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
