package cn.com.duiba.kjy.api.enums.seller;

/**
 * @auther: linjianhui
 * @date: 2020-09-03 10:49
 * @description: 销售内容状态
 */
public enum SellerContentStatusEnum {

    NORMAL(1,"正常"),
    DELETE(2,"已删除"),
    ;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String desc;

    SellerContentStatusEnum(Integer status,String desc){
        this.status = status;
        this.desc = desc;
    }


    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static SellerContentStatusEnum getByStatus(Integer status) {
        for (SellerContentStatusEnum enumVal : SellerContentStatusEnum.values()) {
            if (enumVal.getStatus().equals(status)) {
                return enumVal;
            }
        }
        return null;
    }

}
