package cn.com.duiba.kjy.api.params.survey;

import cn.com.duiba.kjy.api.enums.survey.SurveyChannelValueEnum;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author wutong
 */
@Data
public class SurveySubmitParam implements Serializable {

    private static final long serialVersionUID = -8480059133784798061L;

    /**
     * 问卷Id
     */
    @NotNull(message = "问卷id不能为空")
    private Long surveyId;

    /**
     * 开始填写时间 时间戳
     */
    private Date startAt;

    /**
     * 结束填写时间 时间戳
     */
    private Date endAt;

    /**
     * 版本
     */
    private Integer version;

    /**
     * 开发者(消费)id
     */
    private Long consumerId;

    /**
     * 问题选项必传集合
     */
    @NotNull(message = "问题选择项必传")
    private List<AnswerApiParam> answers;

    /**
     * 场景值
     *
     * @see cn.com.duiba.kjy.api.enums.survey.SurveyChannelValueEnum
     */
    private String channelValue;
}
