package cn.com.duiba.kjy.api.remoteservice.billing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.billing.BillingClockAwardDrawDto;

import java.util.List;

/**
 * 代理人60天开单打卡领取奖励记录remote
 * @author zhanghuifeng
 * date 2020/11/18-15:04
 */
@AdvancedFeignClient
public interface RemoteBillingClockAwardDrawService {

    /**
     * 根据代理人ID和领取状态查询条数
     * @param sellerId 代理人ID
     * @param drawState 领取状态(可不传) {@link cn.com.duiba.kjy.api.enums.billing.BillingClockDrawStateEnum}
     * @return 条数
     */
    int countBySeller(Long sellerId, Integer drawState);

    /**
     * 根据代理人ID和奖励配置ID集合查询信息
     * @param sellerId  代理人ID
     * @param awardConfIds 奖励配置ID，tb_billing_clock_award_conf主键ID
     * @return 集合
     */
    List<BillingClockAwardDrawDto> listBySellerAwardIds(Long sellerId, List<Long> awardConfIds);

    /**
     * 领取奖励
     * @param sellerId    代理人ID
     * @param awardConfId 奖励配置ID，tb_billing_clock_award_conf主键ID
     * @return
     */
    Boolean drawAward(Long sellerId, Long awardConfId);
}
