package cn.com.duiba.kjy.api.remoteservice.honorary;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.honorary.HonoraryAlbumDetailDto;
import cn.com.duiba.kjy.api.dto.honorary.HonoraryAlbumExtDto;
import cn.com.duiba.kjy.api.dto.honorary.HonoraryAlbumListDto;
import cn.com.duiba.kjy.api.dto.honorary.HonoraryAlbumListForBackendDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.content.SearchHonoraryAlbumParam;

/**
 * 荣誉相册ext rpc服务接口
 * @author liuchao1
 * @date 2020-04-20 11:30
 **/
@AdvancedFeignClient
public interface RemoteHonoraryAlbumExtService {

    /**
     * 分页查询-管理后端专用
     * @param params 分页参数
     * @return 荣誉相册列表及分页参数
     */
    Page<HonoraryAlbumListForBackendDto> findPageForBackend(SearchHonoraryAlbumParam params);

    /**
     * 分页查询-手机端
     * @param params 分页参数
     * @return 荣誉相册列表
     */
    Page<HonoraryAlbumListDto> findPage(SearchHonoraryAlbumParam params);

    /**
     * 根据荣誉相册ID查询(包含扩展信息)
     * @param id 荣誉相册ID，对应tb_content.id
     * @return 荣誉相册详情
     */
    HonoraryAlbumDetailDto findById(Long id);

    /**
     * 根据荣誉相册ID查询扩展信息
     * @param id 荣誉相册D，对应tb_content.id
     * @return 荣誉相册扩展信息
     */
    HonoraryAlbumExtDto findExtById(Long id);

    /**
     * 新增或更新
     * @param dto 荣誉相册详情
     * @return 主键
     * @throws KjyCenterException 新增或更新失败的自定义异常
     */
    Long saveOrUpdate(HonoraryAlbumDetailDto dto) throws KjyCenterException;
}
