package cn.com.duiba.kjy.api.remoteservice.reward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.reward.RewardPushDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-03-15 11:42
 * @descript 活动推动订阅 remoteService
 */
@AdvancedFeignClient
public interface RemoteRewardPushApiService {

    /**
     * 批量新增
     * @param rewardPushes 活动推送
     * @return 插入结果
     */
    Integer batchInsert(List<RewardPushDto> rewardPushes);

    /**
     * 根据活动id、用户id、推送类型查询记录
     * @param activityId 活动id
     * @param liveUserId 用户id
     * @param pushTypes 推送类型
     * @return 结果
     */
    List<RewardPushDto> selectByAidUidTypes(Long activityId, Long liveUserId, List<Integer> pushTypes);

    /**
     * 根据活动id、用户id、推送类型查询记录最大id
     * @param id 活动id
     * @param userId 用户id
     * @param singletonList 推送类型
     * @return id
     */
    Long findIdByAidUidTypes(Long id, Long userId, List<Integer> singletonList);
}
