package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerPartnershipDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;

/**
 * 销售合伙人remote
 * @author zhanghuifeng
 * @date 2021/5/7 14:17
 */
@AdvancedFeignClient
public interface RemoteSellerPartnershipService {

    /**
     * 新增销售合伙人
     * @param dto  合伙人信息
     * @return 结果
     */
    Boolean add(SellerPartnershipDto dto);

    /**
     * 删除销售合伙人
     * @param sellerId 销售ID
     * @return 结果
     */
    Boolean del(Long sellerId);

    /**
     * 分页查询销售合伙人
     * @param query 查询参数
     * @return 集合
     */
    List<SellerPartnershipDto> list4page(PageQuery query);

    /**
     * 获取销售合伙人总数
     * @return 总数
     */
    int count();

    /**
     * 根据销售ID查询
     * @param sellerId 代理人ID
     * @return 合伙人信息
     */
    SellerPartnershipDto findBySellerId(Long sellerId);

    /**
     * 批量查询销售合伙人
     * @param sellerIds 代理人ID集合
     * @return 合伙人列表
     */
    List<SellerPartnershipDto> listBySellerIds(List<Long> sellerIds);

}
