package cn.com.duiba.kjy.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售员抽奖配置表
 * @author lizhi
 * @date 2019/11/16 5:32 PM
 */
@Data
public class SellerActivityConfDto implements Serializable {

    private static final long serialVersionUID = 15738966474422151L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 记录类型：article =文章、seller =名片 activity =活动 daily=日报
     * @see cn.com.duiba.kjy.api.constant.ContentTypeEnum
     */
    private String contentType;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 销售员转载内容ID，对应tb_seller_content.id
     */
    private Long scid;

    /**
     * 页面主标题
     */
    private String pageTitle;

    /**
     * 分享海报小程序码
     */
    private String posterMpQrCode;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}