package cn.com.duiba.kjy.api.dto.invitationLetter;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售员邀请函配置表
 * @author kjj mybatis generator
 * 2020-02-18
 */
@Data
public class SellerInvitationLetterConfDto implements Serializable {

    private static final long serialVersionUID = 15820119616442468L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 邀请函ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 代理人邀请函id，对应tb_seller_content.id
     */
    private Long scid;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 标题/主题
     */
    private String title;

    /**
     * 邀请函主图
     */
    private String mainUrl;

    /**
     * 配置状态，0-预览，1-正式
     * @see cn.com.duiba.kjy.api.enums.invitationLetter.InvitationConfStateEnum
     */
    private Integer confState;

    /**
     * 邀请函内容oss地址
     */
    private String invitationUrl;

    /**
     * 代理人海报图
     */
    private String posterImageUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
