package cn.com.duiba.kjy.api.dto.version;

import lombok.Data;

import java.io.Serializable;

/**
 * 版本配置 处理bean
 * @author 吴文哲
 * @date 2020-04-23 17:49
 **/
@Data
public class VersionItemConfBean implements Serializable {
    private static final long serialVersionUID = -6332404425723845197L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *类型 标签:tag, 资源位:resourceLocator
     * max length = 20
     * not null default = null
     */
    private String itemType;

    /**
     *
     *标签id tb_kjy_tag.id
     * not null default = null
     */
    private Long itemId;

    /**
     *
     *版本 1:通用版,2:保险版,3:教培版
     */
    private Integer version;

    /**
     *
     *权重
     * not null default = 0
     */
    private Integer weight;

    /**
     * 行为
     * @see cn.com.duiba.kjy.api.enums.versionItemConf.VersionItemConfActionTypeEnum
     * 1: 新增 2:修改  3:删除
     */
    private Integer actonType;
}
