package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售CRM客集集公司类型枚举
 * @author zhanghuifeng
 * date 2020/12/3-17:36
 */
public enum CrmCompanyKjjTypeEnum {

    LIVE(1, "直播公司"),

    ;

    private Integer code;
    private String desc;

    CrmCompanyKjjTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmCompanyKjjTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmCompanyKjjTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmCompanyKjjTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
