package cn.com.duiba.kjy.api.remoteservice.articlePrize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.articlePrize.ArticlePrizeWinnerDto;

import java.util.List;

/**
*  Service
* @author xiaotian
* 2020-12-21 15:52:55
*/
@AdvancedFeignClient
public interface RemoteArticlePrizeWinnerService {
    /**
    * 新增记录
    */
	Long save(ArticlePrizeWinnerDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(ArticlePrizeWinnerDto dto);
    /**
    * 根据id获取
    */
    ArticlePrizeWinnerDto getById(Long id);

    /**
     * 批量添加
     * @param articlePrizeWinnerDtos
     * @return
     */
    List<ArticlePrizeWinnerDto> batchInsert(List<ArticlePrizeWinnerDto> articlePrizeWinnerDtos);

    /**
     * 根据奖品配置Id获取中奖人列表
     * @param prizeId
     * @return
     */
    List<ArticlePrizeWinnerDto> selectByPrizeId(Long prizeId);

}
