package cn.com.duiba.kjy.api.remoteservice.home;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.home.SubscriptionArticleChooseDto;
import cn.com.duiba.kjy.api.dto.home.SubscriptionArticleDto;
import cn.com.duiba.kjy.api.dto.home.SubscriptionArticleListDto;
import cn.com.duiba.kjy.api.params.Page;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-03-26 11:14
 * @descript 公众号文章remoteService
 */
@AdvancedFeignClient
public interface RemoteSubscriptionArticleService {

    /**
     * 移至公众号文章列表
     * @param contentId
     * @param adminArticleCollectionId
     * @param subId
     * @param grabContentId
     * @return
     */
    boolean save(Long contentId, Long adminArticleCollectionId, Long subId, Long grabContentId) throws KjyCenterException;

    /**
     * 查询公众号文章列表
     * @param subId
     * @param contentId
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<SubscriptionArticleListDto> listSubscriptionArticle(Long subId, Long contentId, Integer pageIndex, Integer pageSize);

    /**
     * 查询公众号文章总数
     * @param subId
     * @return
     */
    int countSubscriptionArticle(Long subId, Long contentId);

    /**
     * 分页查询公众号文章
     * @param subId
     * @param pageIndex
     * @param pageSize
     * @return
     */
    Page<SubscriptionArticleDto> selectList(Long subId, Integer pageIndex, Integer pageSize);

    /**
     * 获取移至公众号列表是否需要选择公众号
     * @param contentId
     * @param adminArticleCollectionId
     * @return
     */
    SubscriptionArticleChooseDto getIsNeedChooseDto(Long contentId, Long adminArticleCollectionId);

    /**
     * 根据主键下架文章
     * @param id
     * @return
     */
    boolean deleteById(Long id);

    /**
     * 根据爬虫文库ids过滤出从爬虫文库中添加的爬虫文库id
     * @param grabContentIds
     * @return
     */
    List<Long> listExistGrabContentIds(List<Long> grabContentIds);

}
