package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.weekly.SellerWeeklyPublicationDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-08-15 11:29
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerWeeklyPublicationService {

    /**
     * 根据代理人id查询周报列表
     * @param sellerId
     * @return
     */
    List<SellerWeeklyPublicationDto> listWeeklyPublication(Long sellerId);


    /**
     * 根据代理人id和周数返回周报信息
     * @param sellerId
     * @param weekNum
     * @return
     */
    SellerWeeklyPublicationDto selectWeeklyPublicationInfo(Long sellerId, Integer weekNum);

    /**
     * 根据海报id查询
     * @param id
     * @return
     */
    SellerWeeklyPublicationDto listById(Long id);

    /**
     * 查询额外信息
     * @param weeklyId
     * @param extraType
     * @return
     */
    Integer countByExtraType(Long weeklyId, Integer extraType);

    /**
     * 根据周报id和类型查询
     * @param weeklyId
     * @param types
     * @return
     */
    SellerWeeklyPublicationDto listByIdAndType(Long weeklyId, List<Integer> types);

    /**
     * 获取最新一条的周报信息
     * @param sellerId
     * @return
     */
    SellerWeeklyPublicationDto getLastWeeklyPublication(Long sellerId);

}
