package cn.com.duiba.kjy.api.remoteservice.successfulcases;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.successfulcases.SuccessfulCasesDto;
import cn.com.duiba.kjy.api.params.successCases.SuccessfulCasesQueryParam;

import java.util.List;

/**
* 客户成功案例表 Service
* @author chentiecheng
* 2020-9-15 15:45:36
*/
@AdvancedFeignClient
public interface RemoteSuccessfulCasesService {
    /**
    * 新增记录
    */
	Boolean save(SuccessfulCasesDto dto);

    /**
    * 根据id更新
    */
    Boolean updateById(SuccessfulCasesDto dto);
    /**
    * 根据id获取
    */
    SuccessfulCasesDto getById(Long id);

    /**
     * 根据参数获取列表
     * @param param
     * @return
     */
    List<SuccessfulCasesDto> selectListByParam(SuccessfulCasesQueryParam param);

    /**
     * 根据参数统计总数
     * @param param
     * @return
     */
    Long countByParam(SuccessfulCasesQueryParam param);

    /**
     * 根据内容id查找案例
     * @param contentId
     * @return
     */
    SuccessfulCasesDto findByContentId(Long contentId);


    /**
     * 根据内容id查找案例
     * @param contentIds
     * @return
     */
    List<SuccessfulCasesDto> findByContentIdList(List<Long> contentIds);

    /**
     * 更新上下架状态
     * @param id
     * @param status
     * @return
     */
    Boolean updateStatusById(Long id,Integer status);

    /**
     * 根据内容id更新状态
     * @param contentId
     * @param status
     * @return
     */
    Boolean updateStatusByContentId(Long contentId,Integer status);
}
