package cn.com.duiba.kjy.api.remoteservice.timingLottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.timingLottery.TimingLotteryStatisticsDto;

import java.util.List;

/**
 * Service
 *
 * @author xiaotian
 * 2021-1-6 10:12:22
 */
@AdvancedFeignClient
public interface RemoteTimingLotteryStatisticsService {
    /**
     * 新增记录
     */
    Boolean save(TimingLotteryStatisticsDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(TimingLotteryStatisticsDto dto);

    /**
     * 根据id获取
     */
    TimingLotteryStatisticsDto getById(Long id);

    /**
     * 通过配置Id列表获取统计详情
     *
     * @param configIds
     * @return
     */
    List<TimingLotteryStatisticsDto> getByConfigIds(List<Long> configIds);

    /**
     * 清空新增
     *
     * @param configId
     * @return
     */
    boolean clearNew(Long configId);

}
