package cn.com.duiba.kjy.api.util;

import java.util.Objects;

/**
 * 默认数据标签工具类
 * @Author chentiecheng
 * @Date 2020/1/14 6:08 下午
 */
public class BuildSystemDataTagUtils {

    /**
     * 生成系统默认数据标签
     * @param sharedNum
     * @return
     */
    public static String buildSystemDataTag(Long sharedNum) {
        String systemDataTag = "";
        if (Objects.isNull(sharedNum) || sharedNum == 0) {
            systemDataTag += 1;
            systemDataTag += "千+转发";
        } else if (sharedNum > 0 && sharedNum < 10) {
            systemDataTag += sharedNum;
            systemDataTag += "千+转发";
        } else if (sharedNum >= 10 && sharedNum <= 50) {
            systemDataTag += 1;
            systemDataTag += "万+转发";
        } else if (sharedNum > 50) {
            systemDataTag += 2;
            systemDataTag += "万+转发";
        } else {
            systemDataTag += 1;
            systemDataTag += "千+转发";
        }
        return systemDataTag;
    }
}
