/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.honorary;

import cn.com.duiba.kjy.api.enums.animation.AnimationBizTypeEnum;
import java.util.HashMap;
import java.util.Map;

public enum HonoraryTypeEnum {
    POSTER(1, "\u8363\u8a89\u76f8\u518c\uff08\u6d77\u62a5\uff09"),
    ANIMATION(2, "\u8363\u8a89\u76f8\u518c\uff08\u97f3\u4e50\u76f8\u518c\uff09"),
    VIDEO(3, "\u8363\u8a89\u76f8\u518c\uff08\u89c6\u9891\u76f8\u518c\uff09");

    private Integer type;
    private String desc;
    private static final Map<Integer, HonoraryTypeEnum> ENUM_MAP;

    private HonoraryTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static HonoraryTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static HonoraryTypeEnum getByAnimationBizType(Integer bizType) {
        AnimationBizTypeEnum bizTypeEnum = AnimationBizTypeEnum.getByType(bizType);
        if (bizTypeEnum == null) {
            return null;
        }
        if (bizTypeEnum.equals((Object)AnimationBizTypeEnum.HONORARY_ALBUM_POSTER)) {
            return POSTER;
        }
        if (bizTypeEnum.equals((Object)AnimationBizTypeEnum.HONORARY_ALBUM_ANIMATION)) {
            return ANIMATION;
        }
        return null;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = new HashMap<Integer, HonoraryTypeEnum>();
        for (HonoraryTypeEnum tmp : HonoraryTypeEnum.values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }
}

