/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.enums.crypto.IdConvertBase64Enum;
import cn.com.duiba.kjy.api.util.IdEncodeByBase64;
import cn.com.duiba.kjy.api.util.IdEncodeByNumber;
import java.time.LocalDate;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdMakerUtil {
    private static final Logger log = LoggerFactory.getLogger(IdMakerUtil.class);
    private static final LocalDate cardOverTime = LocalDate.of(2021, 2, 7);

    private IdMakerUtil() {
    }

    public static String encodingIdByBase64(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return IdEncodeByBase64.encodingId(id, IdConvertBase64Enum.DEF);
    }

    public static String encodingIdByBase64(Long id, IdConvertBase64Enum base64Enum) {
        if (Objects.isNull(id) || base64Enum == null) {
            return null;
        }
        return IdEncodeByBase64.encodingId(id, base64Enum);
    }

    public static Long decodingIdByBase64(String encode) {
        return IdEncodeByBase64.decodingId(encode);
    }

    public static Long encodingId2Number(Long id, Integer digit) {
        if (Objects.isNull(digit)) {
            digit = 10;
        }
        return IdEncodeByNumber.encode(id, digit);
    }

    public static Long decodingIdByNumber(Long encode) {
        try {
            return IdEncodeByNumber.decode(encode);
        }
        catch (Exception e) {
            log.info("\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static Long decodingIdByBase64ForScid(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (LocalDate.now().isBefore(cardOverTime) && cn.com.duiba.wolf.utils.NumberUtils.isNumeric((String)value)) {
            Long result = IdMakerUtil.decodingIdByNumber(Long.valueOf(value));
            if (Objects.isNull(result)) {
                log.info("decodingIdByBase64ForScid value ={}", (Object)value);
            } else {
                log.info("decodingIdByBase64ForScid scid ={}", (Object)result);
            }
            return result;
        }
        return IdMakerUtil.decodingIdByBase64(value);
    }

    public static Long decodingIdByNumber(Long encode, Integer digit) {
        if (Objects.isNull(digit) || digit < 9 || digit.intValue() != String.valueOf(encode).length()) {
            return null;
        }
        return IdMakerUtil.decodingIdByNumber(encode);
    }

    public static Long decodingId(String encode) {
        if (NumberUtils.isNumber((String)encode) && encode.length() > 9) {
            return IdMakerUtil.decodingIdByNumber(Long.valueOf(encode));
        }
        return IdMakerUtil.decodingIdByBase64(encode);
    }

    public static Long compatibleDecodingId(String encode, Long compatibleId) {
        Long id = IdMakerUtil.decodingId(encode);
        if (Objects.isNull(id) && NumberUtils.isNumber((String)encode)) {
            id = Long.valueOf(encode);
            if (Objects.nonNull(compatibleId) && id > compatibleId) {
                return null;
            }
        }
        return id;
    }

    public static Long compatibleDecodingIdByBase64(String encode, Long compatibleId) {
        if (NumberUtils.isNumber((String)encode)) {
            Long id = Long.valueOf(encode);
            if (id < compatibleId || compatibleId == -1L) {
                return id;
            }
            return null;
        }
        return IdMakerUtil.decodingId(encode);
    }
}

