package cn.com.duiba.kjy.api.enums.crm.contract;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 签署形式
 * @date 2021/3/16 19:51
 */
public enum CrmContractTypeEnum {

    /**
     * 签署形式 1：电子合同、2：纸质合同
     */
    ELECTRONIC(1, "电子合同"),
    PAPER(2,"纸质合同"),
    ;

    private Integer code;

    private String desc;

    CrmContractTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmContractTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmContractTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static CrmContractTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
