package cn.com.duiba.kjy.api.remoteservice.aivideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.aivideo.AiVideoTemplateDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;
import java.util.Map;

/**
 * ai跟拍service
 * @author chentiecheng
 * @date 2021/4/26 2:44 下午
 */
@AdvancedFeignClient
public interface RemoteAiVideoTemplateService {

    /**
     * 视频模板列表
     * @param query 分页参数
     * @return 视频模板
     */
    List<AiVideoTemplateDto> selectPage(PageQuery query);

    /**
     * 视频模板列表
     * @param query 分页参数
     * @param classificationId 栏目id
     * @return 视频模板
     */
    List<AiVideoTemplateDto> selectPageAndFilter(PageQuery query, Long classificationId);

    /**
     * 查询记录数
     *
     * @return 记录数
     */
    long count();

    /**
     * 查询指定栏目下的视频记录数
     *
     * @param classificationId 栏目id
     * @return 记录数
     */
    long countAndFilter(Long classificationId);

    /**
     * 批量查询栏目下的视频记录数
     *
     * @param classificationIds 视频栏目id集合
     * @return map<classificationId, count>
     */
    Map<Long, Long> batchCountAndFilter(List<Long> classificationIds);

    /**
     * 新增视频模板
     *
     * @param dto 视频模板参数
     * @return true-成功 false-失败
     */
    boolean insert(AiVideoTemplateDto dto);

    /**
     * 更新视频模版
     * @param dto 视频模板参数
     * @return true-成功 false-失败
     */
    boolean update(AiVideoTemplateDto dto);

    /**
     * 删除
     * @param id 主键id
     * @return true-删除成功 false-删除失败
     */
    boolean delete(Long id);

    /**
     * 根据id获取模版详情
     * @param id 主键id
     * @return 详情
     */
    AiVideoTemplateDto findById(Long id);

    /**
     * 根据栏目id查询是否存在视频
     *
     * @param classificationId 栏目id
     * @return true-存在，false-不存在
     */
    boolean existTemplateWithClassificationId(Long classificationId);
}
