package cn.com.duiba.kjy.api.enums.version;

import java.util.Objects;

/**
 * 素材版本枚举
 * @author 吴文哲
 * @date 2020-02-05 10:36
 **/
public enum ContentVersionEnum {

    COMMON_VERSION(1,"通用素材"),
    INSURANCE_VERSION(2,"行业素材-保险"),
    EDU_VERSION(3,"行业素材-教培"),
    TEST_VERSION(99,"测试专用版"),
    ;
    /**
     * 是否启用
     */
    private Integer version;
    /**
     * 描述
     */
    private String desc;

    ContentVersionEnum(Integer version, String desc) {
        this.version = version;
        this.desc = desc;
    }

    public Integer getVersion() {
        return version;
    }

    public String getDesc() {
        return desc;
    }

    public static ContentVersionEnum getByVersion(Integer version){
        for (ContentVersionEnum enumVal : ContentVersionEnum.values()) {
            if (Objects.equals(version, enumVal.getVersion())) {
                return enumVal;
            }
        }
        return null;
    }

}
