package cn.com.duiba.kjy.api.params;

import cn.com.duiba.kjy.api.enums.ContentSellerImportEnum;
import cn.com.duiba.kjy.api.enums.content.ContentSearchSceneEnum;
import cn.com.duiba.kjy.api.enums.content.EsContentSearchSortEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * Created by dugq on 2019-02-13.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class ContentSearchParams extends PageQuery  {

    private static final long serialVersionUID = -5169344283634890459L;

    /**
     * 标题搜索 左匹配
     */
    private String title;

    /**
     * 状态搜索
     */
    private Integer status;

    /**
     * 内容类型
     */
    private String contentType;

    /**
     * 多个内容类型
     */
    private List<String> contentTypeList;

    /**
     * 多状态
     */
    private List<Integer> statusList;

    private Long tag1Id;

    private Long tag2Id;

    /**
     * 一级标签列表
     */
    private List<Long> tag1Ids;

    private Integer publicly;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 是否是销售员上传的
     * @see ContentSellerImportEnum
     */
    private Integer sellerImport;

    /**
     * 内容id列表
     */
    private List<Long> contentIds;

    /**
     * 线索ids
     */
    private List<Long> clueIds;

    /**
     * 查询结束时间
     * gmt_create < endDate
     */
    private Date endDate;

    /**
     * 搜索场景
     */
    private ContentSearchSceneEnum scene;

    /**
     * 内容素材vip版本
     * @see cn.com.duiba.kjy.api.enums.version.ContentVersionEnum
     */
    private Integer contentVersion;

    /**
     * 筛选发布时间（开始）
     */
    private Date startReleaseTime;

    /**
     * 筛选发布时间（结束）
     */
    private Date endReleaseTime;

    /**
     * 排序字段名
     * @see EsContentSearchSortEnum
     */
    private String sort;

    /**
     * 排序类型 asc desc
     */
    private String orderType;

    /**
     * 是否按照发布时间排序
     * true：按照发布时间，不传/false：按照创建时间
     */
    private Boolean releaseTime;

    /**
     * true 分词器采用and模式，不传或者false采用or
     */
    private Boolean analyzer;
}
