package cn.com.duiba.kjy.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.order.WithdrawalOrderDto;
import cn.com.duiba.kjy.api.dto.order.WithdrawalOrderSimpleDto;
import cn.com.duiba.kjy.api.params.order.WithdrawOrderParam;

import java.util.Date;
import java.util.List;

/**
 * 提现订单服务
 * @author zhanghuifeng
 * date 2019-05-21-14:39
 */
@AdvancedFeignClient
public interface RemoteWithdrawalOrderService {

    /**
     * 保存
     * (orderNo返回不为空时 插入成功)
     * @param dto
     * @return
     */
    WithdrawalOrderDto save(WithdrawalOrderDto dto);

    /**
     * 查询提现订单记录
     * @param param
     * @return
     */
    List<WithdrawalOrderDto> findOrderByCondition(WithdrawOrderParam param);


    /**
     * 根据sellerId筛选出某个时间之后的金额累计
     * @param sellerId
     * @param start
     * @return
     */
    WithdrawalOrderSimpleDto findOrdersBySellerIdAndTime(Long sellerId, Date start);
}
