package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.VisitPathFeedbackDto;
import cn.com.duiba.kjy.api.params.seller.SellerVisitPathParam;

import java.util.List;

/**
 * 代理人反馈rpc服务
 * @author 吴文哲
 * @date 2020-02-25 10:34
 **/
@AdvancedFeignClient
public interface RemoteSellerVisitPathFeedbackService {

    /**
     * 根据代理人id  访客id 查找反馈信息
     * @param sellerId
     * @param visitorId
     * @return
     */
    VisitPathFeedbackDto getFeedbackRecordBySellerIdAndVisitorId(Long sellerId, Long visitorId);

    /**
     * 访客id 查找反馈信息列表
     * @param visitorId
     * @return
     */
    List<VisitPathFeedbackDto> getFeedbackRecordByVisitorId(Long visitorId);

    /**
     * 自增标记次数
     * @param id
     * @return
     */
    Integer updateMarkTimes(Long id);

    /**
     * 新增代理人反馈记录
     * @param dto
     * @return
     */
    Integer addSellerVisitPathFeedbackRecord(VisitPathFeedbackDto dto);

    /**
     * 更新反馈记录
     * @param dto
     * @return
     */
    Integer updateFeedbackRecord(VisitPathFeedbackDto dto);

    /**
     * 批量更新
     * @param batchDtoList
     * @return
     */
    Integer batchUpdateFeedbackRecords(List<VisitPathFeedbackDto> batchDtoList);

    /**
     * 根据条件查询反馈记录
     * @param condition
     * @return
     */
    List<VisitPathFeedbackDto> getFeedbackRecordsByCondition(SellerVisitPathParam condition);

    /**
     * 获取需要拦截的用户id列表
     * @param condition
     * @return
     */
    List<Long> getNeedInterceptUserIds(SellerVisitPathParam condition);

}
