package cn.com.duiba.kjy.api.params.wx.menu;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信公众号菜单表
 * @author kjj mybatis generator 
 * @date 2020-10-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxMenuSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16022140871337243L;

    /**
     * 菜单所属公众号主键，tb_official_accounts.id
     */
    private Long oaId;

    /**
     * 菜单类型，1-默认菜单，2-个性化菜单
     * @see cn.com.duiba.kjy.api.enums.wx.WxMenuTypeEnum
     */
    private Integer menuType;

    /**
     * 菜单状态：1-未启用，2-已启用，3-已下架
     * @see cn.com.duiba.kjy.api.enums.wx.WxMenuStatusEnum
     */
    private Integer menuStatus;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;
}