package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerInvitationDto;
import cn.com.duiba.kjy.api.params.SellerLowerQryParam;
import cn.com.duiba.kjy.api.params.seller.SellerDistributionPageQryParams;

import java.util.List;

/**
 * 代理人分销邀请关系remote
 *
 * @author zhanghuifeng
 * @date 2021/5/27 15:09
 */
@AdvancedFeignClient
public interface RemoteSellerInvitationService {

    /**
     * 分页查询销售员下绑定分销人信息(临时绑定关系如果失效了则不显示)
     *
     * @param pageQryParams 查询参数
     * @return 列表
     */
    List<SellerInvitationDto> find4page(SellerDistributionPageQryParams pageQryParams);

    /**
     * 多条件分页查询销售员下绑定分销人信息(临时绑定关系如果失效了则不显示)
     *
     * @param pageQryParams 查询参数
     * @return 列表
     */
    List<SellerInvitationDto> list4page(SellerLowerQryParam pageQryParams);

    /**
     * 查询分销关系条数
     *
     * @param param 参数
     * @return 总条数
     */
    int count4page(SellerDistributionPageQryParams param);

    /**
     * 根据下级销售ID查询邀请关系
     *
     * @param sellerId 销售ID
     * @return 邀请关系数据
     */
    SellerInvitationDto findBySellerId(Long sellerId);

    /**
     * 存在则更新
     *
     * @param dto 参数
     * @return 结果
     */
    Boolean insertExistUpdate(SellerInvitationDto dto);

    /**
     * 根据下级销售ID删除数据
     *
     * @param sellerId 销售ID
     * @return 删除行数
     */
    int delBySellerId(Long sellerId);

    /**
     * 根据上级sellerId查询(排除过期的)
     *
     * @param superiorIds 上级销售ID集合
     * @return 邀请关系
     */
    List<SellerInvitationDto> findBySuperiorIds(List<Long> superiorIds);

    /**
     * 根据上级ID集合查询下级销售ID集合(排除过期的)
     *
     * @param superiorIds 上级销售ID集合
     * @return 下级销售ID集合
     */
    List<Long> findSellerIdsBySuperiorIds(List<Long> superiorIds);
}
